package com.xforceplus.business.tenant.service;

import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.User;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class FixService {
    private final UserDao userDao;

    private final UserService userService;

    public FixService(UserDao userDao, UserService userService) {
        this.userDao = userDao;
        this.userService = userService;
    }

    @Async("threadPoolExecutor")
    public void fixAllUserOrgs() {
        Pageable userPageable = PageableFactory.create(0, 1000);
        Page<User> users;
        do {
            users = userDao.findAll(userPageable);
            for (User user : users) {
                userService.fixUserOrg(user);
            }
            userPageable = users.nextPageable();
        } while (users.hasNext());
    }
}
