/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyConfig.java   2020-09-21 13-57-38
 * Author: Evan
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: roleExcel定义
 * </p>
 * <p>
 * Description: roleExcel定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author dhy
 * <b>Creation Time:</b> 2020-09-22 11-08-00
 * @since V1.0
 */
public class RoleConfigExcel {
    public RoleConfigExcel() {
    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/role/roleExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";

    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "批量角色授权账号";

    /**
     * 业务名称
     */
    public static final String ROLE_EXPORT_BUSINESS_NAME = "角色批量";


    /**
     * 每次导入1000条数据
     */
    public static final int IMPORT_BATCH_SIZE = 1000;

    /**
     * 默认角色表名
     */
    public static final String ROLE_RESOURCESET_REL = "角色功能对照表";

    public static final String ROLE_ACCOUNT_REL = "角色授权列表";

    public static final String ROLE_ACCOUNT_IMPORT_SHEET = "批量角色授权账号";

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(
            new ExcelSheet(0, ROLE_ACCOUNT_REL),
            new ExcelSheet(1, ROLE_RESOURCESET_REL))
            .collect(Collectors.toList());
    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ROLE_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(ROLE_EXPORT_BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();
    /**
     * 服务醘
     */
    private static final List<ExcelSheet> ROLE_ACCOUNT_IMPORT_SHEETS = Stream
            .of(new ExcelSheet(0, ROLE_ACCOUNT_IMPORT_SHEET))
            .collect(Collectors.toList());
    /**
     * 构建导入导出属性 UserAccount
     */
    public static final BusinessAttribute ROLE_ACCOUNT_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(getRoleAccountImportSheets())
            .build();


    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }


    public static List<ExcelSheet> getRoleAccountImportSheets() {
        return ROLE_ACCOUNT_IMPORT_SHEETS;
    }
}
