/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyConfig.java   2020-09-21 13-57-38
 * Author: Evan
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: 服务配置Excel定义
 * </p>
 * <p>
 * Description: 服务配置Excel定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author feihu.wang
 * <b>Creation Time:</b> 2020-09-21 13-57-38
 * @since V1.0
 */
public class TenantExcel {
    public TenantExcel() {
    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/tenant/tenantExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 默认服务配置表名
     */
    public static final String SN_TENANT = "租户信息";

    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "租户信息";
    /**
     * 批处理大小
     */
    private static final Integer IMPORT_BATCH_SIZE = 3000;
    /**
     * 服务醘
     */
    private static List<ExcelSheet> SHEETS = Stream
            .of(new ExcelSheet(0, SN_TENANT))
            .collect(Collectors.toList());
    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
