package com.xforceplus.business.tenant.service;

import com.xforceplus.dao.TenantRelationDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.TenantRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class TenantRelationService {
    private static final Logger logger = LoggerFactory.getLogger(TenantRelationService.class);

    @Autowired
    private TenantRelationDao tenantRelationDao;

    @Autowired
    private TenantService tenantService;

    public List<TenantRelation> findTenantRelationByTenantId(Long tenantId) {
        if (tenantId == null || tenantId < 1) {
            throw new IllegalArgumentException("tenantId 不合法");
        }
        return tenantRelationDao.findByTenantId(tenantId);
    }

    @Transactional(rollbackFor = Exception.class)
    public void addTenantReletion(Long parentTenantId, Long childTenantId) {

        if (parentTenantId == null
                || parentTenantId < 1
                || childTenantId == null
                || childTenantId < 1) {
            throw new IllegalArgumentException("tenantId 不合法");
        }

        if (parentTenantId.equals(childTenantId)) {
            throw new IllegalArgumentException("parent==child, 你这样搞，系统要崩溃的！");
        }

        //校验是否存在该租户
        Tenant parentTenant = tenantService.findById(parentTenantId);
        Tenant childTenant = tenantService.findById(childTenantId);


        List<TenantRelation> tenantRelationList =
                tenantRelationDao.findByParentTenantIdAndChildTenantId(childTenantId, parentTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            throw new IllegalArgumentException("反向关系已经存在，你这样搞，系统真的崩溃了！");
        }

        tenantRelationList =
                tenantRelationDao.findByParentTenantIdAndChildTenantId(parentTenantId, childTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            return;
        }
        TenantRelation tenantRelation = new TenantRelation();
        tenantRelation.setParentTenantId(parentTenantId);
        tenantRelation.setChildTenantId(childTenantId);
        tenantRelationDao.saveAndFlush(tenantRelation);
        return;
    }

    public void deleteTenantReletion(Long parentTenantId, Long childTenantId) {
        if (parentTenantId == null
                || parentTenantId < 1
                || childTenantId == null
                || childTenantId < 1) {
            throw new IllegalArgumentException("tenantId 不合法");
        }

        List<TenantRelation> tenantRelationList =
                tenantRelationDao.findByParentTenantIdAndChildTenantId(parentTenantId, childTenantId);
        if (tenantRelationList != null && tenantRelationList.size() > 0) {
            tenantRelationDao.deleteAll(tenantRelationList);
        }
        return;
    }
}
