/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: TenantUserService.java   2020-12-29 10-08-03
 * Author: Evan
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.bo.user.TenantUserBo;
import com.xforceplus.dto.user.TenantAdminUserDTO;
import com.xforceplus.dto.user.TenantUserDTO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Title: 租户用户服务(接口定义)
 * </p>
 * <p>
 * Description: 租户用户服务（主要用户列表查询、租户与用户关系查询）
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-12-29 10-08-03
 * @since V1.0
 */
public interface TenantUserService {

    /**
     * 根据根据租户ID和角色ID查询
     *
     * @param tenantId 租户ID
     * @param roleId   角色ID
     * @return List<TenantAdminUserDTO>
     */
    List<TenantAdminUserDTO> findTenantAdminUserByTenantId(Long tenantId, Long roleId);

    /**
     * 按租户ID集合查询租户管理员角色
     *
     * @param tenantIds 租户IDs
     * @param roleId    角色
     * @return List<TenantAdminUserDTO>
     */
    List<TenantAdminUserDTO> findTenantAdminUserByTenantIds(Set<Long> tenantIds, Long roleId);


    /**
     * 根据租户ID及用户状态、用户类型查询相关信息
     *
     * @param pageable     分页对象
     * @param tenantUserBo 查询条件
     * @return Page<TenantUserDTO>
     */
    Page<TenantUserDTO> findTenantUsersByTenantId(Pageable pageable, TenantUserBo tenantUserBo);

    /**
     * 根据租户ID、租户Code、租户名称及用户状态、用户类型查询相关信息
     *
     * @param pageable     分页对象
     * @param tenantUserBo 查询条件
     * @return List<TenantAdminUserDTO>
     */
    Page<TenantUserDTO> findTenantUsersByCondition(Pageable pageable, TenantUserBo tenantUserBo);
}
