/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyConfig.java   2020-09-21 13-57-38
 * Author: Evan
 */
package com.xforceplus.business.tenant.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: 服务配置Excel定义
 * </p>
 * <p>
 * Description: 服务配置Excel定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author feihu.wang
 * <b>Creation Time:</b> 2020-09-21 13-57-38
 * @since V1.0
 */
public class UserExcel {
    public UserExcel() {
    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/user/userExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 默认服务配置表名
     */
    public static final String SN_USER = "人员基本信息";

    public static final String SN_USER_ORG = "人员和组织关系";

    public static final String SN_USER_INVOICE_TYPE = "人员和发票类型";

    public static final String SN_USER_DEVICE = "人员和税控设备";

    public static final String SN_USER_TERMINAL = "人员和税控终端";

    public static final String SN_USER_ROLE = "人员和角色";

    public static final String SN_USER_EXT = "人员和扩展字段";

    public static final String BUSINESS_NAME = "用户相关信息";


    public static final Integer IMPORT_BATCH_SIZE = 3000;


    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(
            new ExcelSheet(0, SN_USER),
            new ExcelSheet(1, SN_USER_ORG),
            new ExcelSheet(2, SN_USER_INVOICE_TYPE),
            new ExcelSheet(3, SN_USER_DEVICE),
            new ExcelSheet(4, SN_USER_TERMINAL),
            new ExcelSheet(5, SN_USER_ROLE),
            new ExcelSheet(6, SN_USER_EXT)
    ).collect(Collectors.toList());

    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();


    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
