/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: RoleExcelExportServiceImpl.java   2020-10-27 11-03-25
 * Author: Evan
 */
package com.xforceplus.business.tenant.service.impl;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.business.tenant.service.RoleService;
import org.springframework.stereotype.Service;

import static com.xforceplus.business.excel.ExcelFile.PARAMS_QUERY;
import static com.xforceplus.business.tenant.service.RoleConfigExcel.ROLE_ACCOUNT_REL;
import static com.xforceplus.business.tenant.service.RoleConfigExcel.ROLE_RESOURCESET_REL;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-27 11-03-25
 * @since V1.0
 */
@Service
public class RoleExcelExportServiceImpl implements ExcelWriteService {

    /**
     * 角色服务
     */
    private final RoleService roleService;

    public RoleExcelExportServiceImpl(RoleService roleService) {
        this.roleService = roleService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.ROLE_EXCEL_FILE;
    }

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        RoleModel.Request.Export query = context.getParam(PARAMS_QUERY, RoleModel.Request.Export.class);
        //租户Id
        Long tenantId = context.getFileDTO().getTenantId();
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        for (String sheetName : query.getSheets()) {
            //角色-功能集-资源码-服务包
            if (ROLE_RESOURCESET_REL.equals(sheetName)) {
                simpleExcelWriter.fill(sheetName, this.roleService.findRolesResourcesetRel(tenantId, query));
            }
            //角色-账号
            if (ROLE_ACCOUNT_REL.equals(sheetName)) {
                simpleExcelWriter.fill(sheetName, this.roleService.findRolesRelAccount(tenantId, query));
            }
        }
    }
}
