package com.xforceplus.business.validator;

import com.xforceplus.business.validator.impl.GenderValidatorImpl;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author chenpengpeng
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = GenderValidatorImpl.class)
public @interface GenderValidator {
    String message() default "性别参数不对，可设置为男/女";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
