package com.xforceplus.business.validator;

import com.xforceplus.business.validator.impl.SourceTypeValidatorImpl;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author chenpengpeng
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = SourceTypeValidatorImpl.class)
public @interface SourceTyeValidator {
    String message() default "来源类型设置有无，可设置为内部用户/外部用户";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
