package com.xforceplus.business.validator;

import com.xforceplus.business.validator.impl.CompanyValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.*;

/**
 * @author geewit
 */
@Target({ElementType.TYPE, ElementType.ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(
        validatedBy = {CompanyValidator.class}
)
@Documented
public @interface ValidateCompany {
    String[] actions() default {};

    String message() default "{message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
