package com.xforceplus.business.validator.impl;

import com.xforceplus.business.enums.SourceTypeEnum;
import com.xforceplus.business.validator.SourceTyeValidator;
import org.apache.commons.lang3.StringUtils;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;

/**
 * @author chenpengpeng
 */
public class SourceTypeValidatorImpl implements ConstraintValidator<SourceTyeValidator, String> {


    @Override
    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        Long count = Arrays.stream(SourceTypeEnum.values()).filter(sourceTypeEnum ->StringUtils.equals(sourceTypeEnum.getSourceTypeDesc(), value)).count();
          return count.compareTo(0L) > 0;
     }
}
