package com.xforceplus.business.wechat.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.wechat.WechatInfoApi;
import com.xforceplus.business.wechat.dto.WechatInfoAndPlatformResp;
import com.xforceplus.business.wechat.service.WechatInfoService;
import com.xforceplus.business.wechat.service.WechatMpService;
import com.xforceplus.domain.account.CreateQrcodeReq;
import com.xforceplus.domain.account.WechatConfigReq;
import com.xforceplus.domain.account.WechatConfigResp;
import com.xforceplus.domain.account.WechatInfoResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author lengmz
 */
@SuppressWarnings("all")
@Api(value = "微信信息接口", description = "微信信息接口")
@Controller
public class WechatInfoController implements WechatInfoApi {
    private final static Logger logger = LoggerFactory.getLogger(WechatInfoController.class);

    private final WechatInfoService wechatInfoService;

    private final WechatMpService wechatMpService;

    public WechatInfoController(WechatInfoService wechatInfoService, WechatMpService wechatMpService) {
        this.wechatInfoService = wechatInfoService;
        this.wechatMpService = wechatMpService;
    }

    @Override
    public ResponseEntity<WechatInfoResp> info() {
        WechatInfoResp wechatInfoResp = wechatInfoService.getInfo();
        return ResponseEntity.okWithCode(wechatInfoResp);
    }

    @Override
    public ResponseEntity<WechatConfigResp> config(WechatConfigReq wechatConfigReq) {
        WechatConfigResp wechatConfigResp = wechatInfoService.getConfig(wechatConfigReq.getUrl());
        return ResponseEntity.okWithCode(wechatConfigResp);
    }

    @ApiOperation(value = "生成带参公众号二维码", notes = "生成带参公众号二维码")
    @Override
    public ResponseEntity<String> create(CreateQrcodeReq qrcodeReq) {
        String showUrl = wechatMpService.create(qrcodeReq.getAppid(), qrcodeReq.getSecret(), qrcodeReq.getSceneStr());
        return ResponseEntity.ok(showUrl);
    }


    @ApiOperation(value = "根据userId查询配置和账户关联")
    @ResponseBody
    @RequestMapping(name = "根据userId查询配置和账户关联", value = Path.PREFIX + "/info-platform/users/{userId}", method = RequestMethod.GET)
    public ResponseEntity<WechatInfoAndPlatformResp> queryOpenIdAndPlatform(@PathVariable("userId") Long userId) {
        logger.error("enter queryOpenIdAndPlatform");
        WechatInfoAndPlatformResp wechatInfoAndPlatformResp = wechatInfoService.queryOpenIdAndPlatform(userId);
        return ResponseEntity.ok(wechatInfoAndPlatformResp);
    }
}
