package com.xforceplus.business.wechat.service;

import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;


/**
 * @author lengmz
 * @since 2020/3/13
 */
@Service
@Slf4j
public class TicketService {

    @Autowired(required = false)
    private RestTemplate restTemplate;

    public TicketResp ticket(String accessToken) {
        String routesUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=%s&type=jsapi";
        routesUrl = String.format(routesUrl, accessToken);
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(routesUrl, String.class);
        String response = responseEntity.getBody();
        log.info("response = {}", response);
        TicketResp ticketResp = JsonUtils.fromJson(response, TicketResp.class);
        return ticketResp;
    }

}
