package com.xforceplus.business.wechat.service;

import com.google.common.hash.Hashing;
import com.xforceplus.business.account.service.AccountPlatformRelService;
import com.xforceplus.business.wechat.dto.WechatInfoAndPlatformResp;
import com.xforceplus.dao.WechatInfoDao;
import com.xforceplus.domain.account.WechatConfigResp;
import com.xforceplus.domain.account.WechatInfoResp;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.entity.WechatInfo;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.List;


/**
 * 微信dService
 *
 * @author lengmz
 */
@Service
public class WechatInfoService {
    private final static Logger logger = LoggerFactory.getLogger(WechatInfoService.class);

    private final static String OPEN_ID = "_openId_";

    @Autowired
    private WechatInfoDao wechatInfoDao;
    @Autowired
    private AccountPlatformRelService accountPlatformRelService;
    @Autowired
    private WechatConfigProperties wechatConfigProperties;


    public WechatInfoResp getInfo() {
        WechatInfoResp wechatInfoResp = new WechatInfoResp();
        WechatInfo wechatInfo = wechatInfoDao.findFirstByStatusEquals(1);
        if (wechatInfo != null) {
            wechatInfoResp.setAccessToken(wechatInfo.getAccessToken());
        }
        wechatInfoResp.setAppId(wechatConfigProperties.getAppId());
        wechatInfoResp.setAppSecret(wechatConfigProperties.getAppSecret());
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null && StringUtils.isNotBlank(authorizedUser.getLoginId())
                && authorizedUser.getLoginId().contains(OPEN_ID)) {
            String loginId = authorizedUser.getLoginId();
            int endIndex = loginId.indexOf(OPEN_ID);
            wechatInfoResp.setOpenId(loginId.substring(0, endIndex));
        }
        return wechatInfoResp;
    }

    public WechatInfoResp get() {
        WechatInfoResp wechatInfoResp = new WechatInfoResp();
        WechatInfo wechatInfo = wechatInfoDao.findFirstByStatusEquals(1);
        if (wechatInfo != null) {
            wechatInfoResp.setAccessToken(wechatInfo.getAccessToken());
        }
        wechatInfoResp.setAppId(wechatConfigProperties.getAppId());
        wechatInfoResp.setAppSecret(wechatConfigProperties.getAppSecret());
        return wechatInfoResp;
    }

    @SuppressWarnings("all")
    public WechatConfigResp getConfig(String url) {
        WechatConfigResp wechatConfigResp = new WechatConfigResp();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000);
        String noncestr = RandomStringUtils.randomAlphabetic(32);
        WechatInfo wechatInfo = wechatInfoDao.findFirstByStatusEquals(1);
        String jsapi_ticket = wechatInfo.getJsapiTicket();
        String content = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", jsapi_ticket, noncestr, timestamp, url);
        String signature = Hashing.sha1().hashBytes(content.getBytes(StandardCharsets.UTF_8)).toString();
        wechatConfigResp.setAppId(wechatConfigProperties.getAppId());
        wechatConfigResp.setNoncestr(noncestr);
        wechatConfigResp.setTimestamp(timestamp);
        wechatConfigResp.setSignature(signature);
        return wechatConfigResp;
    }

    public WechatInfoAndPlatformResp queryOpenIdAndPlatform(Long userId) {
        WechatInfoAndPlatformResp wechatInfoAndPlatformResp = new WechatInfoAndPlatformResp();
        WechatInfoResp wechatInfo = this.getInfo();
        if (wechatInfo != null) {
            wechatInfoAndPlatformResp.setWechatInfo(wechatInfo);
        }
        List<AccountPlatformRel> accountPlatformRels = accountPlatformRelService.list(userId, 1);
        if (accountPlatformRels != null && !accountPlatformRels.isEmpty()) {
            wechatInfoAndPlatformResp.setAccountPlatformRelDtoList(accountPlatformRels);
        }
        return wechatInfoAndPlatformResp;
    }
}
