package com.xforceplus.business.wechat.service;

import com.xforceplus.business.account.service.AccountService;
import com.xforceplus.business.pub.service.PubsubService;
import com.xforceplus.config.PubsubConfig;
import com.xforceplus.janus.pubsub.sdk.IMessageListener;
import com.xforceplus.janus.pubsub.sdk.msg.SealedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 监听微信公众号后台事件.
 *
 * @author feihu.wang
 */


//@Component
//@ConditionalOnProperty(prefix = "sub.wx", name = "enable", havingValue = "true")
public class WechatMpEventListener implements IMessageListener, InitializingBean {

    private final static Logger logger = LoggerFactory.getLogger(AccountService.class);

    private final static String WXMP_BIND_PREFIX = "BIND_WX_MP_";

    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private PubsubService pubsubService;

    @Autowired
    private PubsubConfig pubsubConfig;


    @Override
    public boolean onMessage(SealedMessage sealedMessage) {
        final String subscribe = "subscribe";
        final String scan = "scan";
        logger.info("wx.event:{}", sealedMessage.getPayload().getObj());
        Map<String, String> map = (Map) sealedMessage.getPayload().getObj();
        String event = map.get("event");
        if (subscribe.equals(event) || scan.equals(event)) {
            String openId = map.get("fromUserName");
            String bindInfo = map.get("eventKey").replace("qrscene_", "");
            redisTemplate.opsForValue().set(WXMP_BIND_PREFIX + openId, bindInfo);
        }

        pubsubService.acknowlege(sealedMessage);
        return true;
    }

    @Override
    public void afterPropertiesSet() {
        pubsubService.register(pubsubConfig.getAppCode(), this, new String[]{"*"});
    }
}
