package com.xforceplus.business.wechat.service;

import com.google.common.collect.Maps;
import com.xforceplus.business.account.service.AccessTokenResp;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * 微信公众号二维码生成服务。
 *
 * @author feihu.wang
 */
@Service
@Slf4j
public class WechatMpService {

    @Autowired
    private RestTemplate restTemplate;

    public String create(String appId, String secret, String sceneStr) {
        String getTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        String getTicketUrl = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=%s";
        String showQrcodeUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s";
        getTokenUrl = String.format(getTokenUrl, appId, secret);
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(getTokenUrl, String.class);
        String response = responseEntity.getBody();
        log.info("get token:{}", response);
        AccessTokenResp accessTokenResp = JsonUtils.fromJson(response, AccessTokenResp.class);
        if (!StringUtils.isBlank(accessTokenResp.getAccess_token())) {
            getTicketUrl = String.format(getTicketUrl, accessTokenResp.getAccess_token());
            Map<String, Object> request = createQrcodeRequestBody(sceneStr);
            responseEntity = restTemplate.postForEntity(getTicketUrl, request, String.class, Maps.newHashMap());
            response = responseEntity.getBody();
            log.info("get ticket:{}", response);
            TicketResp ticketResp = JsonUtils.fromJson(response, TicketResp.class);
            if (!StringUtils.isEmpty(ticketResp.getTicket())) {
                showQrcodeUrl = String.format(showQrcodeUrl, ticketResp.getTicket());
            }
        }
        return showQrcodeUrl;
    }

    private Map<String, Object> createQrcodeRequestBody(String sceneStr) {
        Map<String, Object> body = new HashMap<>();
        Map<String, Object> action = new HashMap<>();
        Map<String, String> scene = new HashMap<>();
        scene.put("scene_str", sceneStr);
        action.put("scene", scene);
        body.put("action_name", "QR_LIMIT_STR_SCENE");
        body.put("action_info", action);
        return body;
    }

}
