//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.xforceplus.client.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

public class MetricEvent implements Serializable {
    private String eventId;
    private String requestId;
    private String scheme;
    private String httpMethod;
    private String host;
    private String uri;
    private String path;
    private String serviceName;
    private String eventType;
    private Integer status;
    private String loginId;
    private Long tenantId;
    private String tenantName;
    private Long accountId;
    private String userName;
    private Long userId;
    private String tel;
    private String email;
    private String resourceId;
    private String resourceType;
    private String resourceCode;
    private String resourceName;
    private boolean admin;
    private Boolean isRead;
    private String ip;
    @DateTimeFormat(
        pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
        pattern = "yyyy-MM-dd HH:mm:ss",
        timezone = "GMT+8"
    )
    private Date eventTime;
    private String machineHostName;
    private String machineIp;
    private String objectId;
    private String objectType;
    private String objectOperation;
    private String objectOperationDetail;
    private String requestBody;
    private String clientId;
    private Long costTime;
    private Integer responseStatus;


    public String getEventId() {
        return this.eventId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHost() {
        return this.host;
    }

    public String getUri() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getTel() {
        return this.tel;
    }

    public String getEmail() {
        return this.email;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceCode() {
        return this.resourceCode;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public String getIp() {
        return this.ip;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public String getMachineHostName() {
        return this.machineHostName;
    }

    public String getMachineIp() {
        return this.machineIp;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectOperation() {
        return this.objectOperation;
    }

    public String getObjectOperationDetail() {
        return this.objectOperationDetail;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getCostTime() {
        return this.costTime;
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setIsRead(Boolean isRead) {
        this.isRead = isRead;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public void setMachineHostName(String machineHostName) {
        this.machineHostName = machineHostName;
    }

    public void setMachineIp(String machineIp) {
        this.machineIp = machineIp;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setObjectOperation(String objectOperation) {
        this.objectOperation = objectOperation;
    }

    public void setObjectOperationDetail(String objectOperationDetail) {
        this.objectOperationDetail = objectOperationDetail;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setCostTime(Long costTime) {
        this.costTime = costTime;
    }

    public void setResponseStatus(Integer responseStatus) {
        this.responseStatus = responseStatus;
    }


    private MetricEvent(Builder builder) {
        this.setEventType(builder.eventType);
        this.setEventId(builder.eventId);
        this.setTenantId(builder.tenantId);
        IAuthorizedUser userInfo = builder.user;
        if (null != userInfo) {
            this.loginId = userInfo.getLoginId();
            this.tenantId = userInfo.getTenantId();
            this.tenantName = userInfo.getTenantName();
            this.accountId = userInfo.getAccountId();
            this.userName = userInfo.getUsername();
            this.userId = userInfo.getId();
            this.admin = userInfo.isAdmin();
            this.email = userInfo.getEmail();
            this.tel = userInfo.getMobile();
        }
    }

    public static class Builder {
        private IAuthorizedUser user;
        private String eventType;
        private String eventId;
        private Long tenantId;

        public Builder() {
        }

        public Builder tenantId(Long tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder userInfo(IAuthorizedUser user) {
            this.user = user;
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }
        public Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }


        public MetricEvent build() {
            return new MetricEvent(this);
        }
    }

}
