package com.xforceplus.config;

import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

/**
 * @author chenpengpeng@xforceplus.com
 * @date 2021/8/12
 **/

@Slf4j
@Profile({"!default & !test"})
@Configuration
public class ApolloEventListener {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RefreshScope refreshScope;

    @ApolloConfigChangeListener
    public void apolloChangeListener(ConfigChangeEvent changeEvent) {
        applicationContext.publishEvent(new EnvironmentChangeEvent(changeEvent.changedKeys()));
        refreshScope.refreshAll();
        changeEvent.changedKeys().forEach(key -> log.info("properties refresh:{}-->oldValue:{},newValue:{}",
                key, changeEvent.getChange(key).getOldValue(), changeEvent.getChange(key).getNewValue()));
    }
}
