package com.xforceplus.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author chenpengpeng@xforceplus.com
 * @date 2021/11/15
 **/
@Slf4j
@Component
public class ImportExportThreadPool {
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    public static final Integer CORE_POOL_SIZE = 8;

    private ImportExportThreadPool() {
    }

    static {
        THREAD_POOL_EXECUTOR = ThreadPoolConfig.config()
                .corePoolSize(CORE_POOL_SIZE)
                .maximumPoolSize(CORE_POOL_SIZE * 2)
                .queueSize(20000)
                .keepAliveTime(60)
                .timeUnit(TimeUnit.SECONDS)
                .name("i-e-handler")
                .build();
        log.info("import-export thread pool initialized");
    }

    public static ThreadPoolExecutor get() {
        return THREAD_POOL_EXECUTOR;
    }

    @Scheduled(fixedRate = 30, timeUnit = TimeUnit.SECONDS)
    private void info() {
        log.info("import-export-thread-info:current active thread={}, max thread count={},current queue size={},task count={},completed task count={}",
                THREAD_POOL_EXECUTOR.getActiveCount(), THREAD_POOL_EXECUTOR.getLargestPoolSize(), THREAD_POOL_EXECUTOR.getQueue().size(),
                THREAD_POOL_EXECUTOR.getTaskCount(),THREAD_POOL_EXECUTOR.getCompletedTaskCount());
    }
}
