package com.xforceplus.config;

import io.geewit.data.jpa.envers.support.EnversRevisionRepositoryFactoryBean;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;



/**
 * @author geewit
 * @since 2017-04-07
 */
@Configuration(proxyBeanMethods = false)
@EnableTransactionManagement
@EntityScan(basePackages = {JpaConfig.ENTITY_PACKAGES})
@EnableJpaRepositories(basePackages = {JpaConfig.DAO_PACKAGES}, repositoryFactoryBeanClass = EnversRevisionRepositoryFactoryBean.class)
@EnableAutoConfiguration
public class JpaConfig {
    protected final static String DAO_PACKAGES = "com.xforceplus.**.dao";
    protected final static String ENTITY_PACKAGES = "com.xforceplus.**.entity";

//    @Primary
//    @Bean
//    public HibernateTransactionManager transactionManager(SessionFactory sessionFactory) {
//        HibernateTransactionManager transactionManager = new HibernateTransactionManager(sessionFactory);
//        transactionManager.setGlobalRollbackOnParticipationFailure(false);
//        return transactionManager;
//    }
}
