package com.xforceplus.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class RedisPrefixUtilService {

    @Resource
    private MyRedisProperties myRedisProperties;

    public String processPrefix(String origin) {
        if (StringUtils.isBlank(origin)) {
            return origin;
        }
        if (myRedisProperties == null || StringUtils.isBlank(myRedisProperties.getKeyPrefix())) {
            return origin;
        }
        return myRedisProperties.getKeyPrefix().trim() + origin;
    }
}
