package com.xforceplus.constants;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Arrays;

/**
 * @author: duanhy
 * @date: 2021/9/10 10:50
 * @Description:
 */
@Component
@Slf4j
public class EnvProfile {

    public static boolean isCrcProfile;

    @Resource
    private Environment environment;

    @PostConstruct
    public void init() {
        isCrcProfile = Arrays.stream(environment.getActiveProfiles()).anyMatch(p -> StringUtils.contains(p, "crc"));
        log.info("isCrcProfile = {}", isCrcProfile);
    }

    public boolean isCrcProfile() {
        return isCrcProfile;
    }
}
