package com.xforceplus.event.listener;

import com.xforceplus.dao.TenantDao;
import com.xforceplus.entity.Tenant;
import com.xforceplus.event.dto.CompanyNameChanged;
import com.xforceplus.event.model.EntityPostSaveEvent;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 公司保存事件监听器
 * @author geewit
 */
@Slf4j
@Component
public class CompanySaveEventListener {

    private final TenantDao tenantDao;

    public CompanySaveEventListener(TenantDao tenantDao) {
        this.tenantDao = tenantDao;
    }

    /**
     * 公司名称修改同步修改如果原来名称一样的租户名称
     * @param event
     */
    @Transactional(propagation = Propagation.REQUIRES_NEW, isolation = Isolation.READ_COMMITTED,rollbackFor = Exception.class)
    @EventListener(classes = {EntityPostSaveEvent.class}, condition = "event.source instanceof T(com.xforceplus.event.dto.CompanyNameChanged)")
    public void companyNameChangeListener(EntityPostSaveEvent<CompanyNameChanged> event) {
        CompanyNameChanged companyNameChanged = (CompanyNameChanged) event.getSource();
        String preCompanyName = companyNameChanged.getPreCompanyName();
        String postCompanyName = companyNameChanged.getPostCompanyName();
        List<Tenant> tenants = tenantDao.findByCompanyId(companyNameChanged.getCompanyId());
        //协同需求，修改公司名称，需要同时修改同名的租户名称
        tenants.stream()
                .filter(tenant -> StringUtils.equals(tenant.getTenantName(), preCompanyName))
                .forEach(tenant -> {
                    tenant.setTenantName(postCompanyName);
                    tenantDao.saveAndFlush(tenant);
                });
    }
}
