package com.xforceplus.event.listener;

import com.xforceplus.security.strategy.event.RefreshingStrategyCacheEvent;
import com.xforceplus.security.strategy.service.StrategyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * 刷新租户策略事件监听器
 * @author geewit
 */
@Slf4j
@Component
public class RefreshStrategyListener implements ApplicationListener<RefreshingStrategyCacheEvent> {
    private final StrategyService strategyService;

    public RefreshStrategyListener(StrategyService strategyService) {
        this.strategyService = strategyService;
    }

    @Override
    public void onApplicationEvent(RefreshingStrategyCacheEvent event) {
        strategyService.refreshCache();
    }
}
