package com.xforceplus.event.listener;

import com.xforceplus.dao.ResourceDao;
import com.xforceplus.entity.Resource;
import com.xforceplus.event.dto.ResourceCodeChanged;
import com.xforceplus.event.model.EntityPreSaveEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * Resource 保存事件监听器
 *
 * @author geewit
 */
@Slf4j
@Component
public class ResourceSaveEventListener {

    private final ResourceDao resourceDao;

    public ResourceSaveEventListener(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    /**
     * 保存前校验事件监听器
     * @param event 保存前校验事件
     */
    @Transactional(readOnly = true, propagation = Propagation.REQUIRES_NEW, isolation = Isolation.READ_COMMITTED)
    @EventListener(classes = {EntityPreSaveEvent.class}, condition = "event.source instanceof T(com.xforceplus.event.dto.ResourceCodeChanged)")
    public void validCodeListener(EntityPreSaveEvent<ResourceCodeChanged> event) {
        ResourceCodeChanged codeChanged = (ResourceCodeChanged) event.getSource();
        Resource resource = codeChanged.getEntity();
        long count = resourceDao.countByAppIdAndResourceCode(resource.getAppId(), resource.getResourceCode());
        if (count > 0) {
            throw new IllegalArgumentException("已经存在同名的资源码(appId:" + resource.getAppId() + ", code:" + resource.getResourceCode() + ")");
        }
    }

}
