package com.xforceplus.event.subscriber;

import com.xforceplus.security.strategy.event.RefreshingStrategyCacheEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;


/**
 * redis广播消息订阅器
 *
 * @author geewit
 */
@Slf4j
@Service
public class RefreshingStrategyMessageSubscriber implements ApplicationEventPublisherAware, MessageListener {

    private ApplicationEventPublisher publisher;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    /**
     * 订阅到信息后处理方法
     *
     * @param message
     * @param pattern
     */
    @Override
    public void onMessage(Message message, byte[] pattern) {
        String refreshId = new String(message.getBody(), StandardCharsets.UTF_8);
        log.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent(new RefreshingStrategyCacheEvent(refreshId));
        log.info("----------refresh strategy cache done-----------{}", refreshId);
    }
}