package com.xforceplus.jackson.databind.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.config.GlobalProperties;
import org.springframework.beans.BeansException;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.io.IOException;

@SuppressWarnings("all")
@JsonComponent
public class ResponseEntitySerializer extends JsonSerializer<ResponseEntity> implements ApplicationContextAware {
    private final ObjectMapper mapper;

    private final GlobalProperties globalProperties;

    public ResponseEntitySerializer(ObjectMapper mapper, GlobalProperties globalProperties) {
        this.mapper = mapper;
        this.globalProperties = globalProperties;
    }

    @Override
    public void serialize(ResponseEntity value, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("code");
        generator.writeString(value.getCode());
        generator.writeFieldName("message");
        generator.writeString(value.getMessage());
        if (value.getResult() != null) {
            generator.writeFieldName("result");
            boolean defaultViewInclusionEnabled = mapper.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
            boolean jsonViewEnabled = globalProperties != null ? globalProperties.isJsonViewEnabled() : true;
            if (jsonViewEnabled) {
                if (defaultViewInclusionEnabled) {
                    mapper.disable(MapperFeature.DEFAULT_VIEW_INCLUSION);
                }
            }
            String json = mapper.writerWithView(provider.getActiveView()).writeValueAsString(value.getResult());
            if (jsonViewEnabled) {
                if (defaultViewInclusionEnabled) {
                    mapper.enable(MapperFeature.DEFAULT_VIEW_INCLUSION);
                }
            }
            generator.writeRawValue(json);
        }
        generator.writeEndObject();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {

    }
}
