package com.xforceplus.security.login.context;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.request.*;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.model.TwoFactorType;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.http.ResponseCookie;

import java.util.Set;

/**
 * 登录上下文
 * @author geewit
 * @since 2022-02-27
 */
@Builder
@Setter
@Getter
public class LoginContext<T extends LoginRequest> {
    private String loginName;
    private String password;
    private Long currentTenantId;
    private Set<Long> tenantIds;
    private Long accountId;
    private User user;
    private Account account;
    private String token;
    private T loginRequest;
    private LoginTokenResponse response;
    private Captcha captcha;
    private String host;
    private Set<ResponseCookie> cookies;
    @Builder.Default
    private boolean needEncrypt = true;
    @Builder.Default
    private Boolean success = null;

    /**
     * 验证码
     */
    @Builder
    @Setter
    @Getter
    public static class Captcha {
        private Boolean needCaptcha;
        private String value;
        private Long timeout;
    }

    /**
     * 双因素验证
     */
    @Builder
    @Setter
    @Getter
    public static class TwoFactor {
        private TwoFactorType type;
        private Long timeout;
        private TwoFactorResponse response;
    }

    @Builder
    @Setter
    @Getter
    public static class TwoFactorResponse {
        private String processId;
        private String username;
    }

}
