package com.xforceplus.security.login.exception;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.security.login.response.ILoginResponse;
import io.geewit.core.exception.HttpStatus;
import lombok.Getter;

/**
 * 登录异常
 * @author geewit
 */
@JsonIgnoreProperties(
        ignoreUnknown = true
)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Getter
public class AuthenticationException extends RuntimeException implements HttpStatus {
    private final int httpStatus;
    protected final int code;
    private final ILoginResponse response;


    public AuthenticationException(int code, String message) {
        super(message);
        this.code = code;
        this.httpStatus = HttpStatus.OK;
        this.response = null;
    }

    public AuthenticationException(int code, String message, ILoginResponse response) {
        super(message);
        this.code = code;
        this.httpStatus = HttpStatus.OK;
        this.response = response;
    }

    public AuthenticationException(int httpStatus, int code, String message, ILoginResponse response) {
        super(message);
        this.code = code;
        this.httpStatus = httpStatus;
        this.response = response;
    }
}
