package com.xforceplus.security.login.request;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * 密码登录请求报文对象
 * @author geewit
 */
@Getter
public class PasswordLoginRequest implements LoginCaptchaRequest, LoginPasswordRequest {
    @NotBlank(message = "登录账号不能为空")
    private String username;
    @NotBlank(message = "登录密码不能为空")
    private String password;
    private String captcha;
    private String tenantCode;
    private String modules;

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    @Override
    public void setPassword(String password) {
        this.password = StringUtils.trim(password);
    }

    @Override
    public void setCaptcha(String captcha) {
        this.captcha = StringUtils.trim(captcha);
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = StringUtils.trim(tenantCode);
    }

    public void setModules(String modules) {
        this.modules = StringUtils.trim(modules);
    }

    @Override
    public String toString() {
        return "PasswordLoginRequest{" + "username='" + username + '\'' +
                ", captcha='" + captcha + '\'' +
                ", tenantCode='" + tenantCode + '\'' +
                ", modules='" + modules + '\'' +
                '}';
    }
}
