package com.xforceplus.security.login.request;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * 短信登录请求报文对象
 * @author geewit
 */
@Getter
public class SmsLoginRequest implements LoginRequest {
    @NotBlank(message = "手机号码不能为空")
    private String phone;
    @NotBlank(message = "短信验证码不能为空")
    private String smsCode;
    private String msgId;

    public void setPhone(String phone) {
        this.phone = StringUtils.trim(phone);
    }

    public void setSmsCode(String smsCode) {
        this.smsCode = StringUtils.trim(smsCode);
    }

    public void setMsgId(String msgId) {
        this.msgId = StringUtils.trim(msgId);
    }

    @Override
    public String toString() {
        return "SmsLoginRequest{" + "phone='" + phone + '\'' +
                ", smsCode='" + smsCode + '\'' +
                ", msgId='" + msgId + '\'' +
                '}';
    }
}
