package com.xforceplus.security.login.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 双因子密码登录请求报文
 * @author geewit
 */
@Getter
public class TwoFactorPasswordLoginRequest implements LoginCaptchaRequest, LoginPasswordRequest {
    /**
     * 密码
     */
    @ApiModelProperty("密码")
    @JsonProperty("cipher")
    private String password;
    /**
     * 短信/邮件消息id
     */
    private String msgId;

    /**
     * 流程id，二次认证在一个流程里
     */
    private String processId;
    /**
     * 图形验证码
     */
    private String captcha;

    @Override
    public void setPassword(String password) {
        this.password = StringUtils.trim(password);
    }

    public void setMsgId(String msgId) {
        this.msgId = StringUtils.trim(msgId);
    }

    public void setProcessId(String processId) {
        this.processId = StringUtils.trim(processId);
    }

    @Override
    public void setCaptcha(String captcha) {
        this.captcha = StringUtils.trim(captcha);
    }

    @Override
    public String toString() {
        return "TwoFactorPasswordLoginRequest{" + "msgId='" + msgId + '\'' +
                ", processId='" + processId + '\'' +
                ", captcha='" + captcha + '\'' +
                '}';
    }
}
