package com.xforceplus.security.login.request;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 双因子短信登录请求报文
 * @author geewit
 */
@Getter
public class TwoFactorSmsLoginRequest implements LoginRequest {
    /**
     * 短信验证码
     */
    private String cipher;
    /**
     * 短信/邮件消息id
     */
    private String msgId;

    /**
     * 流程id，二次认证在一个流程里
     */
    private String processId;

    public void setCipher(String cipher) {
        this.cipher = StringUtils.trim(cipher);
    }

    public void setMsgId(String msgId) {
        this.msgId = StringUtils.trim(msgId);
    }

    public void setProcessId(String processId) {
        this.processId = StringUtils.trim(processId);
    }

    @Override
    public String toString() {
        return "TwoFactorSmsLoginRequest{" + "cipher='" + cipher + '\'' +
                ", msgId='" + msgId + '\'' +
                ", processId='" + processId + '\'' +
                '}';
    }
}
