package com.xforceplus.security.login.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.domain.account.AccountType;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 登录成功响应对象
 * @author geewit
 */
@Builder
@Getter
@Setter
public class LoginTokenResponse implements ILoginResponse {

    @JsonProperty("loginUrl")
    private String loginUrl;

    @JsonProperty("username")
    private String username;

    @JsonProperty("email")
    private String email;

    @JsonProperty("accountType")
    private AccountType accountType;

    @JsonProperty("telPhone")
    private String telPhone;

    @JsonProperty("modifyPasswordTip")
    private Boolean modifyPasswordTip;

    @JsonProperty("doubleAuthFlag")
    private Boolean doubleAuthFlag;

    @JsonProperty("passwdLength")
    private Integer passwdLength;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @JsonProperty("pwdExpireDate")
    private Date pwdExpireDate;

    @JsonProperty("xforce-saas-token")
    private String token;

}
