package com.xforceplus.security.login.service;

import com.xforceplus.business.tenant.service.TenantService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 租户secret初始化服务
 * @author geewit
 */
@Service
public class TenantSecretService implements InitializingBean {
    public static final Map<Long, String> TENANT_AND_SECRET = new ConcurrentHashMap<>();

    private final TenantService tenantService;

    public TenantSecretService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public void afterPropertiesSet() {
        Map<Long, String> tenantSecretMap = tenantService.allTenantSecrets();
        if (!TENANT_AND_SECRET.isEmpty()) {
            TENANT_AND_SECRET.clear();
        }
        TENANT_AND_SECRET.putAll(tenantSecretMap);
    }
}
