package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.strategy.model.Strategy;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.context.ApplicationContext;

/**
 * 安全策略处理器
 *
 * @param <T> 安全策略配置类型
 * @author geewit
 * @since 2022-02-28
 */
@SuperBuilder
@NoArgsConstructor
public abstract class AbstractStrategyFilter<T extends Strategy> implements StrategyFilter<T> {

    protected ApplicationContext applicationContext;

    protected int priority;

    protected Class<T> strategyClass;

    @Override
    public ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Class<T> getStrategyClass() {
        if (this.strategyClass == null) {
            this.strategyClass = this.strategyClass();
        }
        return this.strategyClass;
    }

}
