package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.model.GenerateTokenStrategy;
import com.xforceplus.security.login.context.LoginContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 生成token策略处理器
 *
 * @author geewit
 * @since 2022-02-28
 */
public interface GenerateTokenFilter extends StrategyFilter<GenerateTokenStrategy> {
    Logger logger = LoggerFactory.getLogger(GenerateTokenFilter.class);

    @Override
    default boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }

        if (loginContext.getUser() == null) {
            logger.info("this {}Filter.loginContext.user = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }

        if (loginContext.getAccount() == null) {
            logger.info("this {}Filter.loginContext.account = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }

        if (loginContext.getResponse() == null) {
            logger.info("this {}Filter.loginContext.response = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    /**
     * 处理安全策略
     *
     * @param loginContext 登录上下文
     */
    default void executeGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.executeGenerateToken is not override, do nothing", this.getStrategyClass().getSimpleName());
    }

    /**
     * 处理安全策略
     *
     * @param loginContext 登录上下文
     */
    default void generateToken(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.generateToken is not override, do nothing", this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.info("this {}Filter.support = false, do nothing", this.getStrategyClass().getSimpleName());
            return;
        }
        this.executeGenerateToken(loginContext);
    }
}
