package com.xforceplus.security.strategy.filter;

import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.model.Strategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 加载Account信息后, 且登录前安全策略处理器
 * @param <T> 安全策略配置类型
 * @author geewit
 * @since  2022-02-28
 */
public interface PostLoadPredicationFilter<T extends Strategy> extends StrategyFilter<T> {
    Logger logger = LoggerFactory.getLogger(PostLoadPredicationFilter.class);

    @Override
    default boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        User user = loginContext.getUser();
        if (user == null) {
            logger.info("this {}Filter.loginContext.user = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        Account account = loginContext.getAccount();
        if (account == null) {
            logger.info("this {}Filter.loginContext.account = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    /**
     * 处理安全策略
     * @param loginContext 登录上下文
     */
    default void executePostLoadPredicate(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.executePostLoadPredicate is not override, do nothing", this.getStrategyClass().getSimpleName());
    }

    default void postLoadPredicate(LoginContext<? extends LoginRequest> loginContext) {
        logger.info("this {}Filter.postLoadPredicate is not override, do nothing", this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.info("this {}Filter.support = false, do nothing", this.getStrategyClass().getSimpleName());
            return;
        }
        this.executePostLoadPredicate(loginContext);
    }

}
