package com.xforceplus.security.strategy.filter;

import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.model.Strategy;
import com.xforceplus.security.login.context.LoginContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 登录请求失败安全策略处理器
 * @param <T> 安全策略配置类型
 * @author geewit
 * @since  2022-02-28
 */
public interface PostLoginFailFilter<T extends Strategy> extends StrategyFilter<T> {
    Logger logger = LoggerFactory.getLogger(PostLoginFailFilter.class);

    @Override
    default boolean support(LoginContext<? extends LoginRequest> loginContext) {
        if (!StrategyFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext == null) {
            logger.info("this {}Filter.loginContext = null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        if (this.getApplicationContext() == null) {
            logger.debug("this {}Filter.applicationContext == null, do nothing", this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    /**
     * 处理安全策略
     * @param loginContext 登录上下文
     */
    default void executePostLoginFail(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.executePostLoginFail is not override, do nothing", this.getStrategyClass().getSimpleName());
    }

    /**
     * 处理安全策略
     * @param loginContext 登录上下文
     */
    default void postLoginFail(LoginContext<? extends LoginRequest> loginContext) {
        logger.debug("this {}Filter.postLoginFail is not override, do nothing", this.getStrategyClass().getSimpleName());
        if (!this.support(loginContext)) {
            logger.debug("this {}Filter.support = false, do nothing", this.getStrategyClass().getSimpleName());
            return;
        }
        this.executePostLoginFail(loginContext);
    }
}
