package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

/**
 * 登录失败需要Captcha的安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class CaptchaStrategy implements Strategy, Comparable<CaptchaStrategy> {
    public static final String CAPTCHA_PREFIX = "LOGIN_CAPTCHA_";

    public static final int DEFAULT_THRESHOLD = 1;

    @Override
    public String getName() {
        return CaptchaStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "登录失败需要验证码的安全策略";
    }

    /**
     * 需要Captcha登录失败次数阈值
     */
    @ApiModelProperty(value = "需要Captcha登录失败次数阈值")
    private Integer threshold = DEFAULT_THRESHOLD;

    private boolean enabled = true;

    @Override
    public int compareTo(@NotNull CaptchaStrategy that) {
        return Integer.compare(ObjectUtils.defaultIfNull(that.threshold, DEFAULT_THRESHOLD),
                ObjectUtils.defaultIfNull(this.threshold, DEFAULT_THRESHOLD));
    }
}
