package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * token生成安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class GenerateTokenStrategy implements Strategy {
    @Override
    public String getName() {
        return GenerateTokenStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "token生成安全策略";
    }

    /**
     *
     */
    @ApiModelProperty(value = "是否允许账号单个登录session")
    private boolean singleSession = false;

    private boolean enabled = true;
}