package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 根据用户名密码加载User策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class LoadUserByPasswordStrategy implements Strategy {
    @Override
    public String getName() {
        return LoadUserByPasswordStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "根据用户名密码加载User策略";
    }

    private boolean enabled = true;
}