package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 根据短信加载User策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class LoadUserBySmsStrategy implements Strategy {
    @Override
    public String getName() {
        return LoadUserBySmsStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "根据短信加载User策略";
    }

    private boolean enabled = true;
}