package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 新建账号安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class NewAccountStrategy implements Strategy {
    @Override
    public String getName() {
        return NewAccountStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "新建账号首次登陆需要执行的策略";
    }

    /**
     * 需要首次登录时绑定联系方式(手机或邮箱)
     */
    @ApiModelProperty(value = "需要首次登录时绑定联系方式(手机或邮箱)", example = "false")
    private Boolean needBindContact = false;

    /**
     * 需要首次登录时修改密码
     */
    @ApiModelProperty(value = "需要首次登录时修改密码", example = "false")
    private Boolean needChangePassword = false;

    private boolean enabled = false;
}
