package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

/**
 * 密码过期需要修改密码安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class PasswordExpiredStrategy implements Strategy, Comparable<PasswordExpiredStrategy> {
    public static final int DEFAULT_EXPIRE_DAYS = 90;
    public static final int DEFAULT_REMIND_DAYS = 30;

    @Override
    public String getName() {
        return PasswordExpiredStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "密码过期需要修改密码安全策略";
    }

    @ApiModelProperty(value = "密码过期天数", example = "90")
    private Integer expireDays = DEFAULT_EXPIRE_DAYS;

    @ApiModelProperty(value = "密码过期提醒天数", example = "30")
    private Integer expireRemindDays = DEFAULT_REMIND_DAYS;

    private boolean enabled = true;

    @Override
    public int compareTo(@NotNull PasswordExpiredStrategy that) {
        return Integer.compare(ObjectUtils.defaultIfNull(that.expireDays, DEFAULT_EXPIRE_DAYS),
                ObjectUtils.defaultIfNull(this.expireDays, DEFAULT_EXPIRE_DAYS));
    }
}
