package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

/**
 * 最近使用过的密码安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class PasswordRepetitionStrategy implements Strategy, Comparable<PasswordRepetitionStrategy> {
    public static final int DEFAULT_REPETITION = 5;

    @Override
    public String getName() {
        return PasswordRepetitionStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "最近使用过的密码安全策略";
    }

    /**
     * 最近使用过的密码保存条数
     */
    @ApiModelProperty(value = "最近使用过的密码保存条数", example = "5")
    private Integer repetition = DEFAULT_REPETITION;

    private boolean enabled = true;

    public String getMessage() {
        return "此密码和最近使用过的密码重复";
    }

    @Override
    public int compareTo(@NotNull PasswordRepetitionStrategy that) {
        return Integer.compare(ObjectUtils.defaultIfNull(this.repetition, DEFAULT_REPETITION),
                ObjectUtils.defaultIfNull(that.repetition, DEFAULT_REPETITION));
    }
}
