package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 加载User完成后校验或装配User的安全策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class PostLoadUserStrategy implements Strategy {
    @Override
    public String getName() {
        return PostLoadUserStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "加载User完成后校验或装配User的安全策略";
    }

    @ApiModelProperty(value = "是否检查User.status", example = "true")
    private boolean checkUserStatus = true;

    @ApiModelProperty(value = "是否检查Account.status", example = "true")
    private boolean checkAccountStatus = true;

    private boolean enabled = true;
}