package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 登录完成回写cookie策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class ResponseCookieStrategy implements Strategy {
    public static final int DEFAULT_MAXAGE = 10;
    @Override
    public String getName() {
        return ResponseCookieStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "登录完成回写cookie策略";
    }

    /**
     * cookie 失效小时数
     */
    @ApiModelProperty(value = "cookie 失效小时数", example = "10")
    private Integer maxAge = DEFAULT_MAXAGE;

    /**
     * cookie 域名
     */
    @ApiModelProperty(value = "cookie 域名", example = "paas.xforceplus.com")
    private String domain;

    /**
     * 是否顶级域名
     */
    @ApiModelProperty(value = "是否顶级域名", example = "true, paas.xforceplus.com -> xforceplus.com")
    private boolean isTopDomain = true;

    private boolean enabled = true;
}
