package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 双因子认证策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class TwoFactorStrategy implements Strategy {
    public static final int DEFAULT_TIMEOUT = 5;

    @Override
    public String getName() {
        return TwoFactorStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "双因子认证策略";
    }

    /**
     * 优先使用的双因子认证类型
     */
    @ApiModelProperty(value = "优先使用的双因子认证类型", example = "MOBILE, EMAIL")
    private TwoFactorType perferType = TwoFactorType.MOBILE;

    /**
     * 验证码失效时间 (分钟)
     */
    @ApiModelProperty(value = "验证码失效时间 (分钟)", example = "5")
    private Integer timeout = DEFAULT_TIMEOUT;

    private boolean enabled = false;
}
