package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 登录成功后更新登录时间策略
 * @author geewit
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
@ToString
@Setter
@Getter
public class UpdateLoginTimeStrategy implements Strategy {
    @Override
    public String getName() {
        return UpdateLoginTimeStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "登录成功后更新登录时间策略";
    }

    private boolean enabled = true;
}
